<?php

/*
Plugin Name: Beepy Chatbot
Plugin URI: https://www.beepychatbot.com
Description: beepychatbot.com Chat brings chat, offline email, and help desk features to your WordPress website.
Version: 1.0.2
Author: beepychatbot.com
Author URI: https://www.beepychatbot.com/
*/

define('BEEPYCHATBOT_BASE_URL',     'https://www.beepychatbot.com/');
define('BEEPYCHATBOT_TEXTDOMAIN', 	'beepychatbot');
define('BEEPYCHATBOT_ICON', 		BEEPYCHATBOT_BASE_URL.'images/smallicon.png');
define('BEEPYCHATBOT_LOGIN_ACTION',	BEEPYCHATBOT_BASE_URL.'client/login/');
define('BEEPYCHATBOT_SIGNUP_URL', 	BEEPYCHATBOT_BASE_URL.'https://www.beepychatbot.com/Registro/?lang=es&cms=wordpress');

add_action('init', 'beepychatbot_init');
add_action('wp_footer', 'beepychatbot_script');

function beepychatbot_init() {
	load_plugin_textdomain( BEEPYCHATBOT_TEXTDOMAIN, false, dirname(plugin_basename(__FILE__)) . '/languages' );
	if(function_exists('current_user_can') && current_user_can('manage_options')) {
        add_action('admin_menu', 'beepychatbot_create_menu');
    } 
}

function beepychatbot_create_menu() {
	add_menu_page('Account Configuration', 'Beepy chatbot', 'administrator', 'beepychatbot_setup', 'beepychatbot_setup', BEEPYCHATBOT_ICON );
}

function beepychatbot_setup() {
	
	$str =  '<div id="icon-options-general" class="icon32"><br/></div>
    		<h2>'.__('SetupTitle',BEEPYCHATBOT_TEXTDOMAIN).'</h2>
			'.__('SetupDescription',BEEPYCHATBOT_TEXTDOMAIN).'<br>
			<br>
			<div id="existingform">
				<div class="metabox-holder">
					<div class="postbox" style="width:600px;">
						<h3 class="hndle"><span>'.__('LoginTitle',BEEPYCHATBOT_TEXTDOMAIN).'</span></h3>
						<div style="padding:20px;">
							<form method="post" action="'.BEEPYCHATBOT_LOGIN_ACTION.'" target="_blank">
								<table class="form-table">
									<tr valign="top">
										<th scope="row">'.__('Username',BEEPYCHATBOT_TEXTDOMAIN).'</th>
										<td><input type="text" name="username" value="" /></td>
									</tr>
									<tr valign="top">
										<th scope="row">'.__('Password',BEEPYCHATBOT_TEXTDOMAIN).'</th>
										<td><input type="password" name="password" value="" /></td>
									</tr>
	 							</table>
								<div style="padding:10px 0px">
									<input type="submit" class="button-secondary" value="'.__('LoginAction',BEEPYCHATBOT_TEXTDOMAIN).'" />
								</div>
							</form>
							<br>
							<div style="padding-top:15px;">
								'.__('SignupTitle',BEEPYCHATBOT_TEXTDOMAIN).'
								<div style="padding:10px 0px">
									<a href="'.BEEPYCHATBOT_SIGNUP_URL.'" target="_blank" data-popup="true">
										<input type="button" class="button-primary" value="'.__('SignupAction',BEEPYCHATBOT_TEXTDOMAIN).'" />
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>';

    echo $str;
}

function beepychatbot_script() {
    
	$str =  "<!-- Beepy chatbot - start script -->"."\n".
		    "<script type=\"text/javascript\">"."\n".
			   "try{"."\n".
			   "var _evU = (('https:' == document.location.protocol) ? 'https://' : 'http://') + 'www.livebeep.com/' + document.domain + '/eye.js';"."\n".
			   "if((_evH=document.location.href.split(/#ev!/)[1])) _evU += '?_e=' +_evH;"."\n".
			   "else if((_evR=/.*\_evV=(\w+)\b.*/).test(_evC=document.cookie) ) _evU += '?_v=' + _evC.replace(_evR,'$1');"."\n".
			   "document.write(unescape('%3Cscript src=\"' + _evU + '\" type=\"text/javascript\"%3E%3C/script%3E'));"."\n".
			   "} catch(e){}"."\n".
			"</script>"."\n".
			"<!-- Beepy chatbot - end script -->";

	echo $str;
}


?>